/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;

public class CustomGuiTexturedRectWrapper
extends CustomGuiComponentWrapper
implements ITexturedRect {
    float scale = 1.0f;
    String texture;
    int textureX;
    int textureY = -1;
    int width;
    int height;
    int color = -1;

    public CustomGuiTexturedRectWrapper() {
    }

    public CustomGuiTexturedRectWrapper(int id, String texture, int x, int y, int width, int height) {
        this.setId(id);
        this.setTexture(texture);
        this.setPos(x, y);
        this.setSize(width, height);
    }

    public CustomGuiTexturedRectWrapper(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        this(id, texture, x, y, width, height);
        this.setTextureOffset(textureX, textureY);
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        this.setSize(nbt.func_74759_k("size")[0], nbt.func_74759_k("size")[1]);
        this.setScale(nbt.func_74760_g("scale"));
        this.setTexture(nbt.func_74779_i("texture"));
        if (nbt.func_74764_b("texPos")) {
            this.setTextureOffset(nbt.func_74759_k("texPos")[0], nbt.func_74759_k("texPos")[1]);
        }
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public int getTextureX() {
        return this.textureX;
    }

    @Override
    public int getTextureY() {
        return this.textureY;
    }

    @Override
    public int getType() {
        return GuiComponentType.TEXTURED_RECT.get();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public ITexturedRect setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public ITexturedRect setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public ITexturedRect setSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public ITexturedRect setTexture(String texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public ITexturedRect setTextureOffset(int offsetX, int offsetY) {
        this.textureX = offsetX;
        this.textureY = offsetY;
        return this;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        nbt.func_74783_a("size", new int[]{this.width, this.height});
        nbt.func_74776_a("scale", this.scale);
        nbt.func_74768_a("color", this.color);
        nbt.func_74778_a("texture", this.texture);
        if (this.textureX >= 0 && this.textureY >= 0) {
            nbt.func_74783_a("texPos", new int[]{this.textureX, this.textureY});
        }
        return nbt;
    }
}

